class Setting {
companyData = null
companySettingPrint = null
    async mainDataCompany() {
        $('.mainBody').html(`
            <div class="container mt-5">
                <div class="card shadow">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0">بيانات الشركة</h5>
                    </div>

                    <div class="card-body">

                        <!-- اللوجو -->
                        <div class="mb-3">
                            <label class="form-label">لوجو الشركة</label>
                            <input type="file" class="form-control" id="logo_company" accept="image/*">

                            <!-- معاينة اللوجو -->
                            <div class="mt-3 text-center">
                                <img id="logo_preview" src="#" alt="معاينة اللوجو"
                                    style="max-width:180px; display:none; border:1px solid #ddd; padding:5px; border-radius:6px;">
                            </div>
                        </div>

                        <!-- اسم الشركة -->
                        <div class="mb-3">
                            <label class="form-label">اسم الشركة</label>
                            <input type="text" class="form-control" id="name_company" placeholder="ادخل اسم الشركة">
                        </div>

                        <!-- النشاط -->
                        <div class="mb-3">
                            <label class="form-label">النشاط التجاري</label>
                            <input type="text" id="type_company" class="form-control" placeholder="مثل: تجارة ملابس، أجهزة، مواد غذائية">
                        </div>

                        <!-- الرقم الضريبي -->
                        <div class="mb-3">
                            <label class="form-label">الرقم الضريبي</label>
                            <input type="text" class="form-control" id="tax_number_company" placeholder="الرقم الضريبي للشركة">
                        </div>

                        <!-- السجل التجاري -->
                        <div class="mb-3">
                            <label class="form-label">السجل التجاري</label>
                            <input type="text" class="form-control" id="tax_company" placeholder="رقم السجل التجاري">
                        </div>

                        <!-- رقم التواصل -->
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">الهاتف</label>
                                <input type="text" class="form-control" id="phone_company" placeholder="رقم الهاتف">
                            </div>

                            <div class="col-md-6 mb-3">
                                <label class="form-label">البريد الإلكتروني</label>
                                <input type="email" class="form-control" id="email_company" placeholder="example@company.com">
                            </div>
                        </div>

                        <!-- العنوان -->
                        <div class="mb-3">
                            <label class="form-label">العنوان</label>
                            <textarea id="address_company" class="form-control" rows="2" placeholder="ادخل عنوان الشركة"></textarea>
                        </div>

                        <!-- زر الحفظ -->
                        <button type="button" onclick="setting.saveMainDataCompany()" class="btn btn-primary w-100">
                            حفظ البيانات
                        </button>

                    </div>
                </div>
            </div>
        `);

        // تفعيل preview بعد ما الفورم يترسم
        this.initLogoPreview();

        // (اختياري) لو عايز تجيب بيانات موجودة وتحطها
        await setting.getDataMainCompany();
    }


    initLogoPreview() {
        $(document).off("change", "#logo_company"); // منع التكرار لو الصفحة اتفتحت تاني
        $(document).on("change", "#logo_company", function (e) {
            const file = e.target.files[0];
            const preview = document.getElementById("logo_preview");

            if (file) {
                preview.src = URL.createObjectURL(file);
                preview.style.display = "block";
            } else {
                preview.src = "#";
                preview.style.display = "none";
            }
        });
    }


    async saveMainDataCompany() {

        const formData = new FormData();

        formData.append("name_company", $("#name_company").val().trim());
        formData.append("type_company", $("#type_company").val().trim());
        formData.append("tax_number_company", $("#tax_number_company").val().trim());
        formData.append("tax_company", $("#tax_company").val().trim());
        formData.append("phone_company", $("#phone_company").val().trim());
        formData.append("email_company", $("#email_company").val().trim());
        formData.append("address_company", $("#address_company").val().trim());

        const logoFile = $("#logo_company")[0].files[0];
        if (logoFile) {
            formData.append("logo_company", logoFile);
        }
        console.log(formData)
        $.ajax({
            url: "model/setting.php",   // غيرها حسب API عندك
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            success: (res) => {
                // alert("تم حفظ إعدادات الطباعة بنجاح ✅");

                new sweetAlert("تم بنجاح","","success")
            },
            error: () => {
                new sweetAlert(" يوجد خطأ","","error")
            }
        });
    }


async getDataMainCompany() {
    $.ajax({
        url: "model/setting.php",
        type: "GET",
        dataType: "json",
        success: (res) => {

            console.log("API Response:", res);

            // تأكد إن فيه data
            if (!res || !res.data) {
                console.warn("No data returned from server");
                return;
            }

            let d = res.data;

            $("#name_company").val(d.name_company || "");
            $("#type_company").val(d.type_company || "");
            $("#tax_number_company").val(d.tax_number_company || "");
            $("#tax_company").val(d.tax_company || "");
            $("#phone_company").val(d.phone_company || "");
            $("#email_company").val(d.email_company || "");
            $("#address_company").val(d.address_company || "");

            // عرض اللوجو Base64
            if (d.logo_company) {
                $("#logo_preview").attr("src", d.logo_company).show();
            }
        },
        error: (xhr) => {
            console.log("Error:", xhr);
        }
    });
}
    ////////////////////

    async invoiceSetting(){
    $('.mainBody').html(`
      <div class="container mt-4">
        <div class="row g-3">

          <!-- اختيار البيانات -->
          <div class="col-lg-4">
            <div class="card shadow-sm">
              <div class="card-header bg-white fw-bold">
                اختيار ما يظهر في الفاتورة
              </div>
              <div class="card-body">

                <div class="form-check mb-2">
                  <input class="form-check-input invOpt" type="checkbox" id="opt_name_company" checked>
                  <label class="form-check-label" for="opt_name_company">اسم الشركة</label>
                </div>

                <div class="form-check mb-2">
                  <input class="form-check-input invOpt" type="checkbox" id="opt_logo_company" checked>
                  <label class="form-check-label" for="opt_logo_company">لوجو الشركة</label>
                </div>

                <div class="form-check mb-2">
                  <input class="form-check-input invOpt" type="checkbox" id="opt_address_company" checked>
                  <label class="form-check-label" for="opt_address_company">العنوان</label>
                </div>

                <div class="form-check mb-2">
                  <input class="form-check-input invOpt" type="checkbox" id="opt_phone_company" checked>
                  <label class="form-check-label" for="opt_phone_company">الهاتف</label>
                </div>

                <div class="form-check mb-3">
                  <input class="form-check-input invOpt" type="checkbox" id="opt_email_company">
                  <label class="form-check-label" for="opt_email_company">البريد الإلكتروني</label>
                </div>

                <hr>

                <!-- رسالة الهيدر -->
                <div class="mb-3">
                  <label class="form-label fw-bold">رسالة الهيدر في الفاتورة</label>
                  <input type="text" id="inv_header_message" class="form-control" oninput="setting.applyLivePreview()"
                         placeholder="مثال: شكراً لتعاملكم معنا">
                </div>

                <button class="btn btn-primary w-100" onclick="setting.saveInvoiceOptions()">
                  حفظ الاختيارات
                </button>

              </div>
            </div>
          </div>

          <!-- Live Preview -->
          <div class="col-lg-8">
            <div class="card shadow-sm">
              <div class="card-header bg-white fw-bold d-flex justify-content-between align-items-center">
                معاينة الفاتورة (Live Preview)

              </div>

              <div class="card-body">
                <div id="invoicePreview" class="p-3 border rounded bg-light"
                     style="max-width:420px;margin:auto">

                  <div class="text-center mb-2">



                    <img id="prev_logo" style="max-width:100px; display:none; margin-bottom:6px;">
                    <h5 id="prev_name" class="mb-1" style="display:none;"></h5>
                    <div id="prev_address" class="small text-muted" style="display:none;"></div>

                    <div class="small text-muted" id="prev_contact" style="display:none;">
                      <span id="prev_phone"></span>
                      <span id="prev_email_wrap" style="display:none;">
                        | <span id="prev_email"></span>
                      </span>
                    </div>
                  </div>

                  <hr>

                  <div class="d-flex justify-content-between small">
                    <div>رقم الفاتورة: <b>#INV-001</b></div>
                    <div>التاريخ: <b>${new Date().toISOString().slice(0,10)}</b></div>
                  </div>

                  <table class="table table-sm mt-3">
                    <thead>
                      <tr>
                        <th>الصنف</th>
                        <th>الكمية</th>
                        <th>السعر</th>
                        <th>الإجمالي</th>
                      </tr>
                    </thead>
                    <tbody>
                      <tr>
                        <td>منتج تجريبي</td>
                        <td>2</td>
                        <td>50</td>
                        <td>100</td>
                      </tr>
                      <tr>
                        <td>منتج تجريبي 2</td>
                        <td>1</td>
                        <td>80</td>
                        <td>80</td>
                      </tr>
                    </tbody>
                  </table>

                  <div class="text-end">
                    <div>الإجمالي: <b>180</b></div>
                    <div>الخصم: <b>0</b></div>
                    <div class="fs-5">الصافي: <b>180</b></div>
                  </div>

                  <hr>
                  <div class="small msg text-center text-muted">
                    شكراً لتعاملكم معنا
                  </div>

                </div>
              </div>
            </div>
          </div>

        </div>
      </div>
    `);

    // 1) هات بيانات الشركة
    await this.getCompanyDataForPreview();


    // 3) شغل Live preview
    this.initLivePreview();
    this.applyLivePreview();
    this.loadInvoiceOptions()
    }



async getCompanyDataForPreview() {
    return new Promise((resolve) => {
      $.ajax({
        url: "model/setting.php",
        type: "GET",
        dataType: "json",
        success: (res) => {
          if (res && res.data) {
            this.companyData = res.data;
          } else {
            this.companyData = {};
          }

          this
          resolve();
        },
        error: () => {
          this.companyData = {};
          resolve();
        }
      });
    });
}

async loadInvoiceOptions( s = 0) {
    return new Promise((resolve) => {
      $.ajax({
        url: "model/setting_print.php",
        type: "GET",
        dataType: "json",
        success: (res) => {
            setting.companySettingPrint = res
            console.log(res)
          if (!res.data) return resolve();
            if(s == 1){
                if(res.data.is_logo == 0){
                    $('.isImg').hide()
                }
                if(res.data.is_name == 0){
                    $('.isName').hide()
                }
                if(res.data.is_address == 0){
                    $('.isAddress').hide()
                }
                if(res.data.is_phone == 0){
                    $('.isPhone').hide()
                }
                if(res.data.is_mail == 0){
                    $('.isMail').hide()
                }
                $('#textHeader').val(res.data.msg || "")

                resolve();
                return null;
            }
          $("#opt_name_company").prop("checked", res.data.is_name == 1);
          $("#opt_logo_company").prop("checked", res.data.is_logo == 1);
          $("#opt_address_company").prop("checked", res.data.is_address == 1);
          $("#opt_phone_company").prop("checked", res.data.is_phone == 1);
          $("#opt_email_company").prop("checked", res.data.is_mail == 1);

          $("#inv_header_message").val(res.data.msg || "");

          this.applyLivePreview();
          resolve();
        },
        error: () => resolve()
      });
    });
}

initLivePreview() {

    // أي تغيير في checkbox يشغل المعاينة
    $(document).off("change", ".invOpt");
    $(document).on("change", ".invOpt", () => this.applyLivePreview());

    // رسالة الهيدر - oninput
    $(document).off("input", "#inv_header_message");
    $(document).on("input", "#inv_header_message", () => this.applyLivePreview());
}


applyLivePreview() {
    const d = this.companyData || {};

    const showName    = $("#opt_name_company").is(":checked");
    const showLogo    = $("#opt_logo_company").is(":checked");
    const showAddress = $("#opt_address_company").is(":checked");
    const showPhone   = $("#opt_phone_company").is(":checked");
    const showEmail   = $("#opt_email_company").is(":checked");

    // NAME
    if (showName && d.name_company) {
      $("#prev_name").text(d.name_company).show();
    } else {
      $("#prev_name").hide();
    }

    // LOGO
    if (showLogo && d.logo_company) {
      $("#prev_logo").attr("src", d.logo_company).show();
    } else {
      $("#prev_logo").hide();
    }

    // ADDRESS
    if (showAddress && d.address_company) {
      $("#prev_address").text(d.address_company).show();
    } else {
      $("#prev_address").hide();
    }

    // PHONE / EMAIL
    let anyContact = false;

    if (showPhone && d.phone_company) {
      $("#prev_phone").text(d.phone_company);
      anyContact = true;
    } else {
      $("#prev_phone").text("");
    }

    if (showEmail && d.email_company) {
      $("#prev_email").text(d.email_company);
      $("#prev_email_wrap").show();
      anyContact = true;
    } else {
      $("#prev_email_wrap").hide();
      $("#prev_email").text("");
    }

    if (anyContact) {
      $("#prev_contact").show();
    } else {
      $("#prev_contact").hide();
    }

    // ===========================
    // النص (msg) — LIVE PREVIEW
    // ===========================
    let message = $("#inv_header_message").val().trim();
    if (message) {
      $(".msg").text(message).show();
      $("#prev_header_msg").text(message).show();
    } else {
      $(".msg").hide();
      $("#prev_header_msg").hide();
    }
}


saveInvoiceOptions() {
    const opts = {
      is_name: $("#opt_name_company").is(":checked") ? 1 : 0,
      is_logo: $("#opt_logo_company").is(":checked") ? 1 : 0,
      is_address: $("#opt_address_company").is(":checked") ? 1 : 0,
      is_phone: $("#opt_phone_company").is(":checked") ? 1 : 0,
      is_mail: $("#opt_email_company").is(":checked") ? 1 : 0,
      msg: $("#inv_header_message").val().trim()
    };

    $.ajax({
      url: "model/setting_print.php",
      type: "POST",
      data: opts,
      success: (res) => {
        // alert("تم حفظ إعدادات الطباعة بنجاح ✅");

        new sweetAlert("تم بنجاح","","success")
      },
      error: () => {
        new sweetAlert(" يوجد خطأ","","error")
      }
    });
}

}

var setting = new Setting();
